//===============================================================================================
// Provides methods to support a progress bar
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================
progressBarCurTick = 0;
progressBarNumTicks = 16;
progressBarTimer = null;
kProgressBarTickId = "prgTck";
kProgressBarFillStart = 119;
kProgressBarBorderStart = 153;

progressBarFillInc = (255-kProgressBarFillStart) / (progressBarNumTicks+1);
progressBarBorderInc = (255-kProgressBarBorderStart) / (progressBarNumTicks+1) ;

//----------------------------------------------------------------------------
function progressBar_init()
{
	var bar = document.getElementById("progress_box");
	if( !bar ) return;
	bar.innerHTML = "";

	var nobr = document.createElement("nobr");
	bar.appendChild(nobr);
	var tick=null, sp=null;
	
	for ( var i = 0; i < progressBarNumTicks; ++i )
	{
		tick = document.createElement("img");
		tick.className="tick";
		tick.src = "../img/clear.gif";
		tick.border=0;
		tick.id = kProgressBarTickId + i;
		tick.style.visibility = "hidden";
		nobr.appendChild(tick);		

		sp = document.createElement("img");
		sp.src = "../img/clear.gif";
		sp.width=2;
		sp.height=1;
		nobr.appendChild(sp);		
	}
}

//----------------------------------------------------------------------------
function progressBar_start()
{
	var fill = kProgressBarFillStart;
	var border = kProgressBarBorderStart;
	var fillHex, borderHex;
	
	for( var i=progressBarNumTicks-1; i>=0; --i )
	{
		e = document.getElementById(kProgressBarTickId+i);
		if(e)
		{
			e._fill = fill;
			e._border = border;
			
			if(fill<255)
			{
				fillHex = fill.toString(16);
				e.style.backgroundColor = "#" + fillHex + "ff" + fillHex;
				
				borderHex = border.toString(16);
				e.style.borderColor = "#" + borderHex + borderHex + borderHex;
				e.style.visibility = "visible";
			}
			else e.style.visibility = "hidden";
			
			fill = Math.ceil( fill+progressBarFillInc );			
			border = Math.ceil( border + progressBarBorderInc );
			if( border>255) border=255;
		}
	}	
	
	progressBarTimer = setTimeout( "_progressBarUpdate()", 250 );	
}

//----------------------------------------------------------------------------
function progressBar_stop()
{
	clearTimeout( progressBarTimer );
	progressBarTimer = null;	
}

//----------------------------------------------------------------------------
function progressBar_setLabel( msg )
{
	var label = document.getElementById("progress_label");
	if(!label) return;
	if(!msg) msg="";
	
	label.innerHTML = msg;
}

//----------------------------------------------------------------------------
function _progressBarUpdate()
{
	var fill, border;
	var fillHex, borderHex;

	// Get the progress bar percent from C++ event handler
	if (parent) 
	{
	 	var msg;
	 	var percent;
		percent = parent.queryProgressBarPercent(); // defined in dataExchange.js
		if (percent != "")
			msg = percent + "% complete";
		else
			msg = "0% complete";
		progressBar_setLabel(msg);		
	}
	
	for( var i=0; i<progressBarNumTicks; ++i )
	{
		e = document.getElementById(kProgressBarTickId+i);
		if( e )
		{			
			border = e._border;
			border = Math.ceil( border+progressBarBorderInc );
			if( border>255) border=255;

			fill = e._fill;			
			fill = Math.ceil( fill+progressBarFillInc );
			if( fill>255 )
			{
				fill=kProgressBarFillStart;			
				border=kProgressBarBorderStart;
			}	
			e._fill = fill;
			e._border = border;
			
			
			if(fill<255)
			{
				fillHex = fill.toString(16);
				e.style.backgroundColor = "#" + fillHex + "ff" + fillHex;
				
				borderHex = border.toString(16);
				e.style.borderColor = "#" + borderHex + borderHex + borderHex;
				e.style.visibility = "visible";
			}
			else e.style.visibility = "hidden";
		}
	}

	progressBarTimer = setTimeout( "_progressBarUpdate()", 200 );
		// Any faster and on a slow machine won't get any CPU cycles to
		// perform the work we are waiting for.
}
